const
    {$IFDEF CBUILDER3} {$EXTERNALSYM DebugCount} {$ENDIF}
{$IFDEF DEBUG}
    DebugCount  = 4096;                { set to any value for debugging }
{$ELSE}
    DebugCount  = 100;
{$ENDIF}

    VOLUMEBASE   = 16384;     { 0 = silence, 16384 = 0 dB, 32768 = +6dB }

    { missing static colors}
    clMdGray     = TColor($A4A0A0);
    clCream      = TColor($F0FBFF);
    clMoneyGreen = TColor($C0DCC0);
    clSkyBlue    = TColor($F0CAA6);

    InvalidId    = -2;        { deviceID identifiers }
    MapperId     = -1;

type
{$IFNDEF WIN32}
    Short           = Smallint;
    UINT            = Word;
    ULONG           = Longint;
    DWORD           = Longint;
    WPARAM          = Word;
    LPARAM          = Longint;
    LRESULT         = Longint;
    MMRESULT        = UINT;              { error return code, 0 means no error }
    TThreadMethod   = procedure of object;
{$ENDIF}

{$IFNDEF DELPHI4}
    {$IFNDEF WIN32}
    LONGLONG        = Comp;
    PLargeInteger   = ^TLargeInteger;
    TLargeInteger   = record
    case Integer of
        0: (LowPart: DWORD;
            HighPart: Longint);
        1: (QuadPart: LONGLONG);
    end;
    {$ENDIF}
    Int64           = comp;
    PInt64          = ^Int64;
    MMLARGE_INTEGER = TLargeInteger;
    MM_int64        = DWORD;
{$ELSE}
    MMLARGE_INTEGER = LARGE_INTEGER;
    MM_int64        = int64;
{$ENDIF}

    PLong           = ^Long;
    Long            = Longint;
    PShortint       = ^ShortInt;
    PSmallInt       = ^SmallInt;
    PCardinal       = ^Cardinal;
    PBoolean        = ^Boolean;

    PFloat          = ^Float;
    Float           = Single;

    PFloatArray     = ^TFloatArray;
    TFloatArray     = array[0..DebugCount] of Float;

    PDouble         = ^Double;

    PDoubleArray    = ^TDoubleArray;
    TDoubleArray    = array[0..DebugCount] of Double;

    PRectArray      = ^TRectArray;
    TRectArray      = array[0..DebugCount] of TRect;

    PPointArray     = ^TPointArray;
    TPointArray     = array[0..DebugCount] of TPoint;

    PLongArray      = ^TLongArray;
    TLongArray      = array[0..DebugCount] of Longint;

    PIntArray       = ^TIntArray;
    TIntArray       = array[0..DebugCount] of Integer;

    PCardinalArray  = ^TCardinalArray;
    TCardinalArray  = array[0..DebugCount] of Cardinal;

    PWordArray      = ^TWordArray;
    TWordArray      = array[0..DebugCount] of Word;

    PSmallArray     = ^TSmallArray;
    TSmallArray     = array[0..DebugCount] of SmallInt;

    PByteArray      = ^TByteArray;
    TByteArray      = array[0..DebugCount] of Byte;

    PBooleanArray   = ^TBooleanArray;
    TBooleanArray   = array[0..DebugCount] of Boolean;

    {$IFDEF WIN32}
    TMMDeviceId     = type integer;
    {$ELSE}
    TMMDeviceId     = -32768..32767;
    {$ENDIF}

    TMMBits         = (b8Bit,b16Bit);
    TMMMode         = (mMono,mStereo,mMultiChannel);
    TMMChannel      = (chBoth,chLeft,chRight);
    TMMSampleRate   = (sr11025,sr22050,sr44100);
    TMMDecayMode    = (dmNone,dmStepUp,dmExponential,dmUniform);
    TMMTimeFormats  = (tfMillisecond, tfByte, tfSample);
    TMMVolumeRange  = 0..VOLUMEBASE;
    TMMEffectVolume = -200..200;
    TMMFeedBack     = -100..100;
    TMMCBMode       = (cmWindow, cmCallback{$IFDEF WIN32},cmThread{$ENDIF});
    TMMFFTWindow    = (fwRectangular,fwHamming,fwHanning,fwBlackman,
                       fwGaussian,fwWelch,fwParzen);

const
    MaxSmallInt     = $7FFF;
    {$IFDEF DELPHI4}
    MaxInt64        = high(int64);
    {$ELSE}
    {$IFDEF CBUILDER3} {$EXTERNALSYM MaxInt64} {$ENDIF}
    MaxInt64        = 9223372036854775807.0;
    {$ENDIF}
